package gov.va.med.mhv.usermgmt.main.registry;

import java.util.Date;

import gov.va.med.mhv.usermgmt.common.enums.Gender;
import gov.va.med.mhv.usermgmt.common.enums.Indicator;

public class PersonalInfo extends ModelObject {
    
    private Name name = null;
    private String mothersMaidenName = null;
    private Date dateOfBirth = null;
    private PlaceOfBirth placeOfBirth = null;
    private Gender gender = null;
    private String ssn = null;
    private Indicator multipleBirthIndicator = null;
    private Alias alias = null;
    private String etnicity = null;
    private String race = null;
    private Address permanentAddress = null;
    private ContactInformation contactInformation = null;
    private String impreciseDateOfBirth = null;
    
    public Name getName() {
        return name;
    }
    /**
     * @param name The name to set.
     */
    public void setName(Name name) {
        this.name = name;
    }

    /**
     * @return Returns the mothersMaidenName.
     */
    public String getMothersMaidenName() {
        return mothersMaidenName;
    }
    /**
     * @param mothersMaidenName The mothersMaidenName to set.
     */
    public void setMothersMaidenName(String mothersMaidenName) {
        this.mothersMaidenName = mothersMaidenName;
    }

    public Date getDateOfBirth() {
        return dateOfBirth;
    }
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    /**
     * @return Returns the placeOfBirth.
     */
    public PlaceOfBirth getPlaceOfBirth() {
        return placeOfBirth;
    }
    /**
     * @param placeOfBirth The placeOfBirth to set.
     */
    public void setPlaceOfBirth(PlaceOfBirth placeOfBirth) {
        this.placeOfBirth = placeOfBirth;
    }

    public Gender getGender() {
        return gender;
    }
    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getSsn() {
        return ssn;
    }
    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    /**
     * @return Returns the multipleBirthIndicator.
     */
    public Indicator getMultipleBirthIndicator() {
        return multipleBirthIndicator;
    }
    /**
     * @param multipleBirthIndicator The multipleBirthIndicator to set.
     */
    public void setMultipleBirthIndicator(Indicator multipleBirthIndicator) {
        this.multipleBirthIndicator = multipleBirthIndicator;
    }

    /**
     * @return Returns the alias.
     */
    public Alias getAlias() {
        return alias;
    }
    /**
     * @param alias The alias to set.
     */
    public void setAlias(Alias alias) {
        this.alias = alias;
    }
    /**
     * @return Returns the etnicity.
     */
    public String getEtnicity() {
        return etnicity;
    }
    /**
     * @param etnicity The etnicity to set.
     */
    public void setEtnicity(String etnicity) {
        this.etnicity = etnicity;
    }
    /**
     * @return Returns the race.
     */
    public String getRace() {
        return race;
    }
    /**
     * @param race The race to set.
     */
    public void setRace(String race) {
        this.race = race;
    }
    /**
     * @return Returns the permanentAddress.
     */
    public Address getPermanentAddress() {
        return permanentAddress;
    }
    /**
     * @param permanentAddress The permanentAddress to set.
     */
    public void setPermanentAddress(Address permanentAddress) {
        this.permanentAddress = permanentAddress;
    }

    /**
     * @return Returns the contactInformation.
     */
    public ContactInformation getContactInformation() {
        return contactInformation;
    }
    /**
     * @param contactInformation The contactInformation to set.
     */
    public void setContactInformation(ContactInformation contactInformation) {
        this.contactInformation = contactInformation;
    }

    /**
     * @return Returns the impreciseDateOfBirth.
     */
    public String getImpreciseDateOfBirth() {
		return impreciseDateOfBirth;
	}

    /**
     * @param impreciseDateOfBirth The impreciseDateOfBirth to set.
     */
	public void setImpreciseDateOfBirth(String impreciseDateOfBirth) {
		this.impreciseDateOfBirth = impreciseDateOfBirth;
	}

    @Override
    public int hashCode() {
        // Not necessary using all value to get hashCode
        Object[] fields = { ssn, dateOfBirth };
        return hashCode(fields);
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final PersonalInfo other = (PersonalInfo) obj;
        // Compare values in order of most likely discriminators
        return areEqual(ssn, other.ssn)
            && areEqual(contactInformation, other.contactInformation)
            && areEqual(dateOfBirth, other.dateOfBirth)
            && areEqual(placeOfBirth, other.placeOfBirth)
            && areEqual(mothersMaidenName, other.mothersMaidenName)
            && areEqual(permanentAddress, other.permanentAddress)
            && areEqual(name, other.name)
            && areEqual(gender, other.gender)
            && areEqual(etnicity, other.etnicity)
            && areEqual(race, other.race)
            && areEqual(alias, other.alias)
            && areEqual(multipleBirthIndicator, other.multipleBirthIndicator);
    }


}

